---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：5-netstat - ネットワーク統計レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **PCB一覧の出力フォーマット詳細**：inet.c等の実装を未読
  2. **インターフェース統計の列詳細**：if.cの実装を未読

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.bin/netstat/main.c` 69-128行目（protox配列）
- E-02: `usr.bin/netstat/main.c` 240-621行目（main関数）
- E-03: `usr.bin/netstat/main.c` 668-728行目（printproto関数）
- E-04: `usr.bin/netstat/main.c` 200-227行目（グローバルフラグ）
- E-05: `usr.bin/netstat/main.c` 624-661行目（fetch_stats関数群）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | protox配列でプロトコル別処理をテーブル駆動管理 | E-01 (69-128行目) | ○ |
| C-02 | 40種類以上のオプションをサポート | E-02 (258行目のgetopt文字列) | ○ |
| C-03 | 8つの出力モード | E-02 (470-617行目の分岐) | ○ |
| C-04 | Jail対応（-j） | E-02 (453-459行目: jail_getid, jail_attach) | ○ |
| C-05 | live変数でライブ/コアダンプ切替 | E-02 (462行目) | ○ |
| C-06 | -xと-Tが排他的 | E-02 (467-468行目) | ○ |
| C-07 | fetch_stats関数でsysctl/kvm統一API提供 | E-05 (624-661行目) | ○ |
| C-08 | -zオプションで統計リセット（sysctlbyname書き込み） | E-05 (631-632行目) | ○ |
| C-09 | IPv6/IPSEC/SCTPはコンパイル時条件付き | E-01 (88-113行目の#ifdef) | ○ |
| C-10 | NETGRAPH対応 | E-01 (170-179行目の#ifdef NETGRAPH) | ○ |
| C-11 | UNIXドメインソケット対応 | E-02 (610-613行目: unixpr) | ○ |
| C-12 | printproto関数でsflagに応じてstats/cblocks切替 | E-03 (675-718行目) | ○ |
| C-13 | BACKWARD_COMPATIBILITY対応（位置引数） | E-02 (436-450行目) | ○ |
| C-14 | kread_counters関数でcounter(9)配列読み取り | E-02 (822-851行目) | ○ |
| C-15 | PCB一覧の出力フォーマット詳細（ソケット列情報） | **根拠なし**（inet.c未読） | △ |
| C-16 | インターフェース統計の列詳細（MTU, パケット等） | **根拠なし**（if.c未読） | △ |

## 4) 不足情報（Unknown / Missing）
- inet.c, if.c, route.c等の個別プロトコルモジュールの出力フォーマット詳細
  - 候補：`usr.bin/netstat/inet.c` / `usr.bin/netstat/if.c` / `usr.bin/netstat/route.c`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 複数ファイルに分散した処理のうち、main.c以外の出力フォーマット詳細が未確認

## 6) レビュアーチェックリスト（最小）
- [ ] inet.cのprotopr関数の出力フォーマットを確認
- [ ] if.cのintpr関数のインターフェース統計カラムを確認
- [ ] route.cのroutepr関数のルーティングテーブル出力を確認
- [ ] SCTP/SDP等の条件付きコンパイルの影響範囲を確認
